const express = require('express');
const path = require('path');
const https = require('https');
const fs = require('fs');
const app = express();

app.use(express.static(path.join(__dirname, 'build')));

app.get('*', (req, res) => {
  res.sendFile(path.join(__dirname, 'build', 'index.html'));
});

const PORT = process.env.PORT || 5000;
const options = {
  key: fs.readFileSync('./server.key'),
  cert: fs.readFileSync('./server.cert')
};
https.createServer(options, app).listen(PORT, () => {
  console.log(`Frontend running in production mode on https://localhost:${PORT}`);
});
